//
//  Copyright © 2025 Kyle Hughes. All rights reserved.
//  SPDX-License-Identifier: MIT
//

import Foundation

final class SendableTap: Sendable {
    private let onFire: @Sendable () -> Void
    
    init(_ onFire: @escaping @Sendable () -> Void) {
        self.onFire = onFire
    }
    
    func fire() {
        onFire()
    }
}